dofile(current_mod_path.."/Views.lua")

FLYER_1 =  {
        
	Name 				=   'Flyer1',
	DisplayName			= _('1903 Wright Flyer'),
	
	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	
	Picture 			= current_mod_path..'/ImagesGui/Flyer1.png',
	Rate 				= 5,
	Shape 				= "Flyer1",
	
	shape_table_data 	= 
	{
		{
			file  	 = 'Flyer1';
			life  	 = 18; --18 lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'N3D-crush109a'; -- Name of destroyed object file name
			fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'Flyer1';
			index    =  WSTYPE_PLACEHOLDER;
		},
		{
			name  = "N3D-crush109a";
			file  = "N3D-crush109a";
			fire  = { 240, 2};
		},

	},
	--34-36 might be the cap
	net_animation = {
						600, 
						601, 
						602, 
						603, 
						604,
						605,
						606,
					},
					
	mapclasskey 		= "P0091000025",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, Flyer1, "Battleplanes",},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	

	ViewSettings = {
	Cockpit = {
	[1] = {-- player slot 1
		cockpit_local_point    = {-0.06,0.106,-0.31},
		CameraViewAngleLimits  = {20.000000,120.000000},
		CameraAngleRestriction = {false,60.000000,0.400000},
		CameraAngleLimits      = {140.000000,-75.000000,90.000000},
		EyePoint               = {0.000000,0.000000,0.000000},
		limits_6DOF            = {x = {-0.050000,0.450000},y ={-0.200000,0.200000},z = {-0.220000,0.220000},roll = 90.000000},
	},
	[2] = {-- player slot 2
		cockpit_local_point    = {-0.06,0.106,-0.81},
		CameraViewAngleLimits  = {20.000000,120.000000},
		CameraAngleRestriction = {false,60.000000,0.400000},
		CameraAngleLimits      = {140.000000,-75.000000,90.000000},
		EyePoint               = {0.000000,0.000000,0.000000},
		limits_6DOF            = {x = {-0.050000,0.450000},y ={-0.200000,0.200000},z = {-0.220000,0.220000},roll = 90.000000},
	},
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {4.259000,3.819000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-12.041000,6.419000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
},		
--------------------------------------------------------------------------------------------------------------------------------------------------------------
	M_empty 					= 300,--690.89           
	M_nominal 					= 331, --780          
	M_max 						= 338, --850.09          
	M_fuel_max 					= 0.624,--393.3748077,
	H_max 					 	= 12436, -- m
	stores_number				= 0,
	average_fuel_consumption 	= 0.305, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 50, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 93,-- Cruise speed (for AI)
	V_take_off 					= 40, -- Take off speed in m/s (for AI)
	V_land 						= 43, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 173, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 184, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 23.2, -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.8, -- Max speed in Mach (for AI)
	Ny_min 						= -4, -- Min G (for AI)
	Ny_max 						= 8.0,  -- Max G (for AI)
	Ny_max_e 					= 8.0,  -- Max G (for AI)
	AOA_take_off 				= 0.16, -- AoA in take off (for AI)
	bank_angle_max 				= 60, -- Max bank angle (for AI)
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no
--------------------------------------------------------------------------------------------------------------------------------------------------------------
	 tand_gear_max				= 0.577,
	 
	 nose_gear_pos								=  {2.52,	-0.918,	0}, -- nosegear coord 
	 nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	 nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	 nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	 nose_gear_wheel_diameter 	              	=  0.155, -- in m
	
	 main_gear_pos 								= 	{ -1.125, -0.933, 0.697}, -- main gear coords	 
	 main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	 main_gear_amortizer_reversal_stroke  	    = 	0, --  up 
	 main_gear_amortizer_normal_weight_stroke   =   0,-- down from main_gear_pos
	 main_gear_wheel_diameter 				    =   0.343, -- in m
--------------------------------------------------------------------------------------------------------------------------------------------------------------
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	wing_area 					= 47.4, -- wing area in m2  31.99
	wing_span 					= 12.3, -- wing spain in m 13.06
	wing_type 					= 0,   --fixed wing     2 fold wings
	thrust_sum_max 				= 9000, -- thrust in kg (44kN)
	thrust_sum_ab 				= 9000, -- thrust inkg (71kN)
	length 						= 6.4, -- full length in m 10.24
	height 						= 2.8, -- height in m 3.99
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 1778, -- Max range in km (for AI)
	RCS 						= 0.1, -- Radar Cross Section m2
	crew						= 1,
	IR_emission_coeff 			= 0.2, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	wing_tip_pos 				= {500,	500,	500}, -- wingtip coords for visual effects
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	engines_count				= 1, -- Engines count
	engines_nozzles = {
		[1] = 
		{
			pos 		=  {0.6,-0.8, 0}, -- nozzle coords
			elevation   =  0, -- AFB cone elevation
			diameter	 = 0.3, -- AFB cone diameter
			exhaust_length_ab   = 0.631, -- lenght in m
			exhaust_length_ab_K = 0.56, -- AB animation
			smokiness_level = 0.00,
			engine_number  = 1, --both to first engine
		}, -- end of [1]
	}, -- end of engines_nozzles
	crew_members = 
	{
		[1] =                                                                          
		{
			pilot_name		  	 = "pilot_p51",
			ejection_seat_name	 = 0,
			drop_canopy_name 	 = "Flyer1_Canopy",
			pos					 =  {-1.1,	-0.1,	0}, --{-0.603,	0.9,	0},
			canopy_pos			 = {0,0,0},
			can_be_playable 	 = true,
			g_suit               =  10, -- Edge can now pull x g without blackout
		}, -- end of [1]
		
		[2] =                                                                          
		{
			pilot_name		  	 = "pilot_p51",
			ejection_seat_name	 = 0,
			drop_canopy_name 	 = "Flyer1_Canopy",
			pos					 =  {-0.603,	0.1,	0},
			canopy_pos = {0,0,0},
			can_be_playable 		= true,
			g_suit               =  10, -- Edge can now pull x g without blackout
		}, -- end of [2]
		
	}, -- end of crew_members

	AddPropAircraft = {
		{ id = "SoloFlight" 			, control = 'checkbox' , label = _('Solo Flight')			   , defValue = false, weightWhenOn = -85},
		{ id = "NetCrewControlPriority" , control = 'comboList', label = _('Aircraft Control Priority'), playerOnly = true,
		  values = {{id =  0, dispName = _("Pilot")},
					{id =  1, dispName = _("Instructor")},
					{id = -1, dispName = _("Ask Always")},
					{id = -2, dispName = _("Equally Responsible")}},
		  defValue  = 1,
		  wCtrl     = 0 --150
		},

		
	},

	fires_pos = 
	{
		[1] = 	{-2.117,	-0.9,	0},
		[2] = 	{0.500,	0.213,	0},
		[3] = 	{0.500,	0.213,	-2.182},
		[4] = 	{-0.82,	0.265,	2.774},
		[5] = 	{-0.82,	0.265,	-2.774},
		[6] = 	{-0.82,	0.255,	2.7274},
		[7] = 	{-0.82,	0.255,	-2.7274},
		[8] = 	{0.5,	-0.5,	2.7578},
		[9] = 	{0.5,	-0.5,	-2.578},
		[10] = 	{0.50,	0.084,	2.754},
		[11] = 	{0.50,	0.084,	-2.7534},
	}, -- end of fires_pos
	
	effects_presets = {
		--{effect = "APU_STARTUP_BLAST", preset = "F18", ttl = 3.0},
		--{effect = "SMOKE_TRAIL", file = current_mod_path.."/Effects/Smoke.lua"},
	},
	
	-- Countermeasures
	SingleChargeTotal	 	= 0,
	CMDS_Incrementation 	= 0,
	ChaffDefault 			= 0, 
	ChaffChargeSize 		= 0,
	FlareDefault 			= 0, 
	FlareChargeSize 		= 0,
	CMDS_Edit 				= false,

	detection_range_max		 = 0,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = {
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	
	Sensors = {},
	
    HumanRadio = {
        frequency = 254.0, -- Maykop (Caucasus) or Nellis (NTTR)
        editable = true,
        minFrequency = 225.000,
        maxFrequency = 399.900,
        modulation = MODULATION_AM
    },

    panelRadio = {
        [1] = {
            name = _("AN/ARC-27A"),
            range = {
                {min = 225.0, max = 399.9}
            },
            channels = {  -- matches L-39C except for channel 8, which was changed to a Georgian airport and #20 which is NTTR only (for now).  This radio goes 1-20 not 0-19.
                [1] = { name = _("Channel 1"),		default = 264.0, modulation = _("AM"), connect = true}, -- mineralnye-vody (URMM) : 264.0
                [2] = { name = _("Channel 2"),		default = 265.0, modulation = _("AM")},	-- nalchik (URMN) : 265.0
                [3] = { name = _("Channel 3"),		default = 256.0, modulation = _("AM")},	-- sochi-adler (URSS) : 256.0
                [4] = { name = _("Channel 4"),		default = 254.0, modulation = _("AM")},	-- maykop-khanskaya (URKH), nellis (KLSV) : 254.0
                [5] = { name = _("Channel 5"),		default = 250.0, modulation = _("AM")},	-- anapa (URKA) : 250.0
                [6] = { name = _("Channel 6"),		default = 270.0, modulation = _("AM")},	-- beslan (URMO) : 270.0
                [7] = { name = _("Channel 7"),		default = 257.0, modulation = _("AM")},	-- krasnodar-pashkovsky (URKK) : 257.0
                [8] = { name = _("Channel 8"),		default = 258.0, modulation = _("AM")},	-- sukhumi-babushara (UGSS) : 255.0
                [9] = { name = _("Channel 9"),		default = 262.0, modulation = _("AM")},	-- kobuleti (UG5X) : 262.0
                [10] = { name = _("Channel 10"),	default = 259.0, modulation = _("AM")},	-- gudauta (UG23) : 259.0
                [11] = { name = _("Channel 11"),	default = 268.0, modulation = _("AM")},	-- tbilisi-soganlug (UG24) : 268.0
                [12] = { name = _("Channel 12"),	default = 269.0, modulation = _("AM")},	-- tbilisi-vaziani (UG27) : 269.0
                [13] = { name = _("Channel 13"),	default = 260.0, modulation = _("AM")},	-- batumi (UGSB) : 260.0
                [14] = { name = _("Channel 14"),	default = 263.0, modulation = _("AM")},	-- kutaisi-kopitnari (UGKO) : 263.0
                [15] = { name = _("Channel 15"),	default = 261.0, modulation = _("AM")},	-- senaki-kolkhi (UGKS) :  261.0
                [16] = { name = _("Channel 16"),	default = 267.0, modulation = _("AM")},	-- tbilisi-lochini (UGTB) : 267.0
                [17] = { name = _("Channel 17"),	default = 251.0, modulation = _("AM")},	-- krasnodar-center (URKI), creech (KINS) : 251.0
                [18] = { name = _("Channel 18"),	default = 253.0, modulation = _("AM")},	-- krymsk (URKW), mccarran (KLAS) : 253.0
                [19] = { name = _("Channel 19"),	default = 266.0, modulation = _("AM")},	-- mozdok (XRMF) : 266.0
                [20] = { name = _("Channel 20"),	default = 252.0, modulation = _("AM")}, -- N/A, groom lake/homey (KXTA) : 252.0
            }
        },
    },

	Pylons =  {  
		-- pylon(1, 0, 0, 0, 0, {
		-- use_full_connector_position = true,
		-- connector = "SMOKE",
		-- FiX = 0,
		-- FiY = 0,
		-- FiZ = 30,
		-- },
		-- {
		-- 	-- { CLSID = "{SMOKE_OIL_WHITE}"},--1
        --     -- { CLSID = "{SMOKE_OIL_RED}"},--2
        --     -- { CLSID = "{SMOKE_OIL_BLUE}"},--3
        --     -- { CLSID = "{SMOKE_OIL_GREEN}"},--4
        --     -- { CLSID = "{SMOKE_OIL_YELLOW}"},--5
        --     -- { CLSID = "{SMOKE_OIL_ORANGE}"},--6
        --     -- { CLSID = "{SMOKE_OIL_PURPLE}"},--7
        --     -- { CLSID = "{SMOKE_OIL_MAGENTA}"},--8
        --     -- { CLSID = "{SMOKE_OIL_PINK}"},--9
		-- }),
	},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
        --aircraft_task(GAI),
		aircraft_task(GroundAttack),
     	aircraft_task(CAS),
        aircraft_task(PinpointStrike),
        aircraft_task(SEAD),
		aircraft_task(AFAC),
	    aircraft_task(RunwayAttack),
		aircraft_task(Reconnaissance),
		aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(Intercept),

	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.2,      -- zero AoA lift coefficient
			Mzalfa		=	4.355,  -- coefficients for pitch agility
			Mzalfadt	=	0.8,    -- coefficients for pitch agility
			kjx			=	2.25,    
			kjz			=	0.00125, 
			Czbe		=	-0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.0277,    -- coefficient, drag, gear 0.0277
			cx_flap		=	0.095,   -- coefficient, drag, full flaps
			cy_flap		=	0.31,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{	--        M		 Cx0	 Cya	  B		 B4	    Omxmax	   Aldop   Cymax
						{0.0,	0.0187,	0.0746,		0.052,	0.012,	0.15,		22.0,		1.45,	},
						{0.2,	0.0187,	0.0746,		0.052,	0.012,	0.796144,	22.0,		1.45,   },
						{0.3,	0.0187,	0.0722,		0.052,	0.015,	1.24,		19.0,		1.2,    },
						{0.5,	0.0187,	0.0798,		0.045,	0.025,	1.323,		17.0,		1.08,   },
						{0.59,	0.0187,	0.084,		0.047,	0.026,	1.129077,	17.0,		1.07,   },
						{0.67,	0.0187,	0.0907,		0.047,	0.021,	0.943,		14.5,		0.98,   },
						{0.74,	0.0227,	0.0855,		0.08,	0.16,	0.675,		10.0,	  	0.72,   },
						{0.76,	0.032,	0.078,		0.1,	0.25,	0.577,		9.0,  		0.6,    },
						{0.8,	0.063,	0.072,		0.2,	0.36,	0.456,		6.0,	    0.4,	},
						{0.83,	0.1,	0.0725,		0.34,	2.4,	0.32,		4.5,		0.3,	},
						{0.9,	0.126,	0.073,		0.56,	3.0,	0.076,		3.0,	    0.2,	},
						{1.1,	0.16,	0.03,		0.56,	3.0,	0.076,		1.0,		0.3		},
			
			}, -- end of table_data
			
		}, -- end of aerodynamics
		
--Powerplant: 1 × Pratt & Whitney R-2800-30W two-row radial engine, 2,250 hp (1,678 kW)		
		engine = 
		{
			Nmg	=	167.5, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	1, -- Military power state of the throttle
			ForsRUD	=	1, -- Afterburner state of the throttle
			typeng	=	2,
---			typeng	=	3,
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN	= 4
				E_TURBOSHAFT = 5
			--]]
			
			hMaxEng	=	12.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0015, -- Engine drag coeficient
			cemax	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	1800, --  altitude coefficient for max thrust
			dpdh_f	=	1800,  --  altitude coefficient for AB thrust
			k_adiab_1			= 0.037923,
			k_adiab_2			= 0.0562,
			MAX_Manifold_P_1	= 155774,		
			MAX_Manifold_P_2	= 206570,		
			MAX_Manifold_P_3	= 226648,		
			k_after_cool		= 0.54,
			Displ				= 27,
			k_Eps				= 6,
			Stroke				= 0.152,
			V_pist_0			= 18,
			Nu_0				= 1.4,
			Nu_1				= 1.2,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220,
			D_prop				= 3.45,
			MOI_prop			= 65,
			k_gearbox			= 2.088,
			P_oil				= 495438,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 4500,
			k_reg				= 0.005,
			k_vel				= 0.020,
			
			table_data = 
			{		--   M		Pmax		 Pfor	
			
			--   M			Pmax
				{0.0,		24000.0},
				{0.1,		22000.0},
				{0.2,		18000.0},
				{0.3,		16640.0},
				{0.4,		14460.0},
				{0.5,		12600.0},
				{0.6,		11200.0},
				{0.7,		10100.0},
				{0.8,		9940.0},
				{0.9,		5904.0},
				{1.9,		3938.0},
			}
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	},
--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
Damage = {
	[11]		= {critical_damage = 3, args = {147}}, -- engine l
	[39]		= {critical_damage = 2, args = {242}}, -- fin top left
	[43]		= {critical_damage = 5, args = {243}, deps_cells = {39, 54, 45, 46, 49, 50}}, -- fin bottom left
	[54]		= {critical_damage = 1, args = {247}}, -- rudder right
	[45]		= {critical_damage = 2, args = {235}}, -- stabilizer out left
	[47]		= {critical_damage = 3, args = {236}, deps_cells = {49}} ,-- stabilizer in left
	[46]		= {critical_damage = 2, args = {233}}, -- stabilizer out right
	[48]		= {critical_damage = 3, args = {234}, deps_cells = {50}}, -- stabilizer in right
	[49]		= {critical_damage = 1, args = {240}},-- elevator out left
	[50]		= {critical_damage = 1, args = {238}},-- elevator out right
	[4]			= {critical_damage = 2, args = {154}},-- cabin left
	[5]			= {critical_damage = 2, args = {153}},-- cabin right
	[82]		= {critical_damage = 3, args = {152}},-- fuselage bottom
	[56]		= {critical_damage = 3, args = {158}},-- tail left
	[57]		= {critical_damage = 3, args = {157}},-- tail right
	[55]		= {critical_damage = 6, args = {81}, deps_cells = {43, 54, 45, 46}}, -- tail 
	[3]			= {critical_damage = 1, args = {65}}, -- cockpit 
	[59]		= {critical_damage = 3, args = {148}}, -- nose bottom 
	[1]			= {critical_damage = 2, args = {150}}, -- nose left
	[2]			= {critical_damage = 2, args = {149}}, -- nose right
	[24]		= {critical_damage = 6, args = {213}, deps_cells = {26}},-- wing out right 
	[30]		= {critical_damage = 7, args = {214}, deps_cells = {24, 26, 38}},-- wing center right 
	[36]		= {critical_damage = 7, args = {215}, deps_cells = {30, 24, 26, 38}}, -- wing in right 
	[26]		= {critical_damage = 1, args = {216}}, -- eleron right 
	[38]		= {critical_damage = 2, args = {217}},-- flap in right 
	[23]		= {critical_damage = 6, args = {223}, deps_cells = {25}}, -- wing out left
	[29]		= {critical_damage = 7, args = {224}, deps_cells = {23, 25, 37}}, -- wing center left 
	[35]		= {critical_damage = 7, args = {225}, deps_cells = {29, 23, 25, 37}}, -- wing in left 
	[25]		= {critical_damage = 1, args = {226}}, -- eleron left 
	[37]		= {critical_damage = 2, args = {227}}, -- flap in left 
	[83]		= {critical_damage = 2, args = {134}}, -- wheel nose 
	[85]		= {critical_damage = 3, args = {135}}, -- wheel right 
	[84]		= {critical_damage = 3, args = {136}}, -- wheel left 
	[63]		= {critical_damage = 3, args = {53}, deps_cells = {66, 69, 72, 75}}, -- rotor
	[63]		= {critical_damage = 3, args = {53}}, -- rotor
	[66]		= {critical_damage = 3, args = {270}}, -- blade 1 out
	[69]		= {critical_damage = 3, args = {271}}, -- blade 2 out
	[72]		= {critical_damage = 3, args = {272}}, -- blade 3 out
	[75]		= {critical_damage = 3, args = {273}}, -- blade 4 out
    ["TAIL"]				= {critical_damage = 3, args = {81},deps_cells = {"KIL_L","RUDDER","STABILIZER_L_OUT","STABILIZER_R_OUT"}},
	
--------- Rotor/Propeller ---------------------------------------------------------

	[64]		= {critical_damage = 3, args = {429}}, -- blade 1 in  (for contact model!)
	[67]		= {critical_damage = 3, args = {430}}, -- blade 2 in  (for contact model!)
	[70]		= {critical_damage = 3, args = {431}}, -- blade 3 in  (for contact model!)
	[73]		= {critical_damage = 3, args = {119}}, -- blade 4 in  (for contact model!)
			
	},
	
	DamageParts = 
	{  
		[1] = "oblomok-wing-r", -- wing R
		[2] = "oblomok-wing-l", -- wing L
--		[3] = "F6F5_Canopy", -- canopy
--		[4] = "F6F5-oblomok-tail", -- tail
	},
	

	lights_data = {
	typename = "collection",
	lights = {

    --[[
	[1] = { typename = "collection",
						lights = {-- Left Anticollision Light
								  {typename = "natostrobelight", connector = "WHITE_BEACON L", argument_1 = 195, period = 1.2, phase_shift = 0},
								  -- Right Anticollision Light
								  {typename = "natostrobelight", connector = "WHITE_BEACON R", argument_1 = 196, period = 1.2, phase_shift = 0},
								  -- Tail Anticollision Light
								  {typename = "natostrobelight",
								   connector = "BANO_0_BACK",
								   argument_1 = 192,
								   period = 1.2,
								   phase_shift = 0
								  }
								 }
									  },
	[2] = { typename = "collection",
							lights = {-- Landing light
									  {typename = "spotlight",
									   connector = "MAIN_SPOT_PTR_02",
									   argument = 209,
									   dir_correction = {elevation = math.rad(-1)}
									  },
									  {-- Landing/Taxi light
									   typename = "spotlight",
									   connector = "MAIN_SPOT_PTR_01",
									   argument = 208,
									   dir_correction = {elevation = math.rad(3)}
									  }
									 }
						},
    [3]	= {	typename = "collection",
						lights = {-- Left Position Light (red)
								  {typename = "omnilight",
								   connector = "BANO_1",
								   color = {0.99, 0.11, 0.3},
								   pos_correction  = {0, 0, 0},
								   argument  = 190
								  },
								  -- Right Position Light (green)
								  {typename = "omnilight",
								   connector = "BANO_2",
								   color = {0, 0.894, 0.6},
								   pos_correction = {0, 0, 0},
								   argument  = 191
								  },
								  -- Tail Position Light (white)
								  {typename = "omnilight",
								   connector = "BANO_0_BACK",
								   color = {1, 1, 1},
								   pos_correction  = {0, 0, 0},
								   argument  = 203
								  }}
									},
[4] = { typename = "collection", -- white strobe upper
	lights = {
				{typename = "natostrobelight",connector = "WHITE_TOP",argument_1 = 192,period = 1.0,color = {0.8, 0.8, 1.0},phase_shift = 0.0},
			 }
		},
	[5]	= {typename = "collection",
			lights = {
						{typename = "collection",
						lights = {{
								-- Right Nacelle Floodlight
								typename = "spotlight",
								position  = {0.5, 1.2, 0},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(150), elevation = math.rad(5)},
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {
								-- Left Nacelle Floodlight
								typename = "spotlight",
								position  = {0.5, 1.2, 0},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(-150), elevation = math.rad(5)},
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {typename  = "argumentlight", argument = 212},
						},
					},
						{typename = "collection",
						lights = {{
								-- Left Nose Floodlight
								typename  = "spotlight",
								position  = {0, -0.3, -5.80},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0, angle_max = 0.45,
								direction = {azimuth = math.rad(45)},
								argument = 211,
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {
								-- Right Nose Floodlight
								typename = "spotlight",
								position  = {0, -0.3, 5.80},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(-45)},
								argument = 210,
								dont_change_color = false,
								angle_change_rate = 0
							   }
						}
					},
		 [6]	= {typename = "collection",
								lights = {-- red recognotion light 
								{typename = "omnilight",
								 connector = "FORM_LIGHTS_1",
								 color = {0.99, 0.11, 0.3},
								 pos_correction  = {0, 0, 0},
								 argument  = 200
								},
								 -- amber recognotion light 
								{typename = "omnilight",
								connector = "FORM_LIGHTS_2",
								color = {1.0, 0.5, 0.0},
								pos_correction = {0, 0, 0},
								argument  = 202
								},
								-- green recognotion light 
								{typename = "omnilight",
								connector = "FORM_LIGHTS_3",
								color = {0, 0.894, 0.6},
								pos_correction  = {0, 0, 0},
								argument  = 201
								}}
							},
					-- UARRSI light
					{
						typename = "omnilight", position  = {6.5, 0.4, 0}, color = {1, 1, 1}
					}
				  },
			}
	--]]
			}
				},

	
	ViewSettings = ViewSettings,
	SnapViews	 = SnapViews,	
	
--	Countries = {"USA", "UK"},
---------------------------------------------------------------------------------------------------------------------------------------------	

}

add_aircraft(FLYER_1)